this.name        = "deep_space_dredger"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "This script places the dredger in deep space."; 
this.version     = "1.2"; 

this.reset = function()
{
    this.dredger = true
    if(this.dredgerTimer)
        this.dredgerTimer.start()
    else
        this.dredgerTimer = new Timer(this, this.dredgerCheck, 150, 120)
}

this.shipExitedWitchspace = function()
{
    if(system.isInterstellarSpace) return;
    if(system.techLevel > 8 && Math.random() < 0.5) this.dredger = true;
    else
    {
        this.dredger = false
        if(system.techLevel > 8 && Math.random() < 0.05) system.legacy_addShipsAt("dredger", 1, "pwp", 0.5, 0.5, 20)
    }
}


this.dredgerCheck = function()
{
    if(this.dredger && player.position.distanceTo(system.mainPlanet.position) > 1500000 && player.speed > player.maxSpeed) 
    { 
        this.addDredger(); 
        if(Math.random()< 0.5) this.dredger = false 
    }
}

this.addDredger = function()
{
    if (oolite.compareVersion("1.71") > 0) return; // Don'y do anything in pre 1.71 versions.
    let orientation = player.orientation; orientation.w = -orientation.w
    // correct player orientation. Might be corrected in 1.72
    let forwardPosition = player.position.add(orientation.vectorForward().multiply(300000))
    system.legacy_addShipsAtPrecisely("dredger", 1, "abs", forwardPosition)
    if(Math.random()<0.5) 
    {
        system.legacy_addShipsWithinRadius("asteroid", Math.ceil(Math.random()*3), "abs", forwardPosition, 10000)
        system.legacy_addShipsWithinRadius("miner", Math.ceil(Math.random()*3), "abs", forwardPosition, 10000)
    }
}